<?php
require_once( 'utility.php' ) ;

function prepare_dda_deployment( $argv ) {
    global $DTASCFG_XML_FILE, $BACKEND ;
    
    $sc_id = "1" ;
    $scInfoArray = ConfManager::getScInfo( $sc_id ) ;
    $msInfoArray = ConfManager::getMsInfo( $sc_id ) ;
    $esxiInfoArray = ConfManager::getEsxiInfo( $sc_id ) ;
    
    $usbxcli = ConfManager::get( "/configuration/u_sandbox/cli_path" ) ;
    $network_label_to_controller = ConfManager::get( "/configuration/cli/network_label_to_controller" ) ;
    $network_label_esxi_ms_sc    = ConfManager::get( "/configuration/cli/network_label_esxi_ms_sc" ) ;

    try {
    
        # power-off SC
        ScManager::powerOffById( $sc_id ) ;

        # make sure ESXi hostname is not empty
        $esxiHostname = EsxiManager::getHostname( $sc_id ) ;
        if( $esxiHostname == "" || $esxiHostname == null ) {
            EsxiManager::setHostname( $sc_id, "ddaesxi" ) ;
        }

        # make sure ESXi domain is not empty
        $esxiDomain = EsxiManager::getDomain( $sc_id ) ;
        if( $esxiDomain == "" || $esxiDomain == null ) {
            EsxiManager::setDomain( $sc_id, "dda.com" ) ;
        }
        
        # if IP '169.254.4.1' exists, that means customers follow our Administration Guide
        # to re-configure their ESXi with private IP. Thus, we have to ensure that every ESXi traffic
        # is routed to MS, namely '169.254.3.2'.
        $esxiIpArray = EsxiManager::getIp( $sc_id ) ;
        if( in_array( "169.254.4.1", $esxiIpArray, true ) == true ) {
            debug_print( "IP '169.254.4.1' found, set ESXi default gateway to '169.254.3.2'" ) ;
            EsxiManager::setDefaultGateway( $sc_id, "169.254.3.2" ) ;
        }
        else {
            debug_print( "IP '169.254.4.1' not found, skip setting ESXi default gateway to '169.254.3.2'" ) ;
        }

        # enable ESXi SSH service
        EsxiManager::enableSshService( $sc_id ) ;

        # set ESXi to get DNS by static way
        # #DTAS-1919 [3.0SP1][DDA3.0][Deployment] DDA fails to disable ESXi's DNS and DHCP setting on the starting of deployment
        #   When esxi has been configured to disable DHCP DNS, then disable it again, it will raise an exception.
        #   Our purpose is the next step 'set DNS server'. Thus, igonre the exception and go for next step.
        try {
            CommonUtility::stepRunProgramAtMs( array(
                "stepname"  => "DisableEsxiDnsDhcp",
                "program"   => "/usr/bin/vicfg-dns",
                "arguments" => array(
                    "--server",    $esxiInfoArray[ "ip" ],
                    "--username",  $esxiInfoArray[ "username" ],
                    "--password",  $esxiInfoArray[ "password" ],
                    "--dhcp",      "no"
            ) ) ) ;
        }
        catch( Exception $e ) {
            $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
            CommonUtility::debug_print( "Ignore exception: $msg" ) ;
        }

        # set DNS server for ESXi
        try {
            CommonUtility::stepRunProgramAtMs( array(
                "stepname"  => "SetEsxiDnsConf",
                "program"   => "/usr/bin/vicfg-dns",
                "arguments" => array(
                    "--server",    $esxiInfoArray[ "ip" ],
                    "--username",  $esxiInfoArray[ "username" ],
                    "--password",  $esxiInfoArray[ "password" ],
                    "--dhcp",      "no",
                    "--dns",       $msInfoArray[ "dns" ]
            ) ) ) ;
        }
        catch( Exception $e ) {
            $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
            CommonUtility::debug_print( "Ignore exception: $msg" ) ;
        }

        # configure SC's 'Network Adapter 1' to 'esxi-ms-sc'
        EsxiManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "NetworkAdapter1ToPortGroup",
            "program"   => "/bin/sed",
            "arguments" => array(
                "-i",
                "s/ethernet0.networkName = .*/ethernet0.networkName = $network_label_esxi_ms_sc/",
                $scInfoArray[ "image_path" ]
        ) ) ) ;
        
        # power-on SC
        ScManager::powerOnById( $sc_id ) ;
        
        # configure ip
        ScManager::setNetworkConfiguration( $sc_id, array(
            "nic"     => "eth0",
            "dhcp"    => "0",
            "ip"      => $scInfoArray[ "ip" ],
            "mask"    => $scInfoArray[ "netmask" ],
            "gateway" => $scInfoArray[ "gateway" ],
            "dns"     => $msInfoArray[ "dns" ]
        ) ) ;
  
        # ensure that SC's ssh service is available */
        ScManager::waitUntilSshable( $sc_id, true, array(
            "retry_max"      => 10,
            "retry_interval" => 10
        ) ) ;

        # stop spcd services
        ScManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "StopSpcd", 
            "program"   => "/sbin/service",
            "arguments" => array(
                "spcd",
                "stop" ) ) ) ;

        # [Usbx] set-esxi
        // CommonUtility::debug_print( "SetEsxiForUsbx: ip='$esxi_ip', username='$esxi_username'" ) ;
        ScManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "SetEsxiForUsbx", 
            "program"   => "/usr/bin/python", 
            "arguments" => array(
                $usbxcli,   "set-esxi",
                "--host",   $scInfoArray[ "esxi_ip" ],
                "--user",   $scInfoArray[ "esxi_username" ],
                "--passwd", $scInfoArray[ "esxi_password" ] ) ),
            array('--user', '--passwd')
        ) ;
        // CommonUtility::debug_print( "SetEsxiForUsbxSuccess: $stdoutMsg" ) ;

        # wait for service 'postgresql' ready
        ScManager::waitUntilServiceState( $sc_id, "postgresql", "is running" ) ;

        # [usbx] sys-init
        ScManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "InitUsbx", 
            "program"   => "/usr/bin/python", 
            "arguments" => array( $usbxcli,
                                  "sys-init" ) ) ) ;
        // CommonUtility::debug_print( "InitUsbxSuccess: $stdoutMsg" ) ;

        # power-off SC
        ScManager::powerOffById( $sc_id ) ;
        
        # configure SC's 'Network Adapter 2' to 'toController'
        // CommonUtility::debug_print( "Attach SC's 'Network Adapter 2' to portgroup: $network_label_to_controller" ) ;
        EsxiManager::stepRunProgramBySsh( $sc_id, array(
            "stepname"  => "NetworkAdapter1ToPortGroup",
            "program"   => "/bin/sed",
            "arguments" => array(
                "-i",
                "s/ethernet1.networkName = .*/ethernet1.networkName = $network_label_to_controller/",
                $scInfoArray[ "image_path" ]
        ) ) ) ;
        
        # power-on SC
        ScManager::powerOnById( $sc_id ) ;

        # ensure that SC's ssh service is available */
        ScManager::waitUntilSshable( $sc_id, true, array(
            "retry_max"      => 10,
            "retry_interval" => 10
        ) ) ;

        # ensure that SC's 'Network Adapter 2' is enabled
        CommonUtility::stepRunProgramAtMs( array(
            "stepname"  => "EnsureScNetworkAdapter2Connected",
            "program"   => "/usr/bin/vmware-cmd",
            "arguments" => array(
                "--server",   $scInfoArray[ "esxi_ip" ],
                "--username", $scInfoArray[ "esxi_username" ],
                "--password", $scInfoArray[ "esxi_password" ],
                $scInfoArray[ "image_path" ],
                "connectdevice",
                "Network adapter 2"
        ) ) ) ;
        
        EsxiManager::disableSshService( $sc_id ) ;
    }

    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        shm_print_error( $msg ) ;
        CommonUtility::debug_print( "Exception caught: $msg" ) ;
        
        EsxiManager::disableSshService( $sc_id ) ;
        exit( 1 ) ;
    }
    
    return ;
}

